;==================================================================================
; Rugal's -2 states
;==================================================================================
[Statedef -2]
;============================
; ---------- AI ------------
;============================
[State -2, StopAI]
type = VarSet
triggerall = var(58) > 0
trigger1 = RoundState != 2
trigger2 = !Alive
var(58) = -2
IgnoreHitPause = 1

[State -2, Simplifier]
type = VarSet
trigger1 = var(58) = 1
trigger2 = var(0):=0
var(0) = 1	; Another option is to replace 1 with something like MatchNo, if
		; you want to design your AI to have varying levels of difficulty.
IgnoreHitPause = 1

;============================
; ------- MAX CODING ------- 
;============================

;MAX CODING
[State -2, max]
type = VarAdd 
trigger1 = var(24) > 0
trigger1 = stateno != 900
ignorehitpause = 1
var(24) = -1

;MAX CODING
[State -2, max]
type = VarSet
trigger1 = var(24) < 0
trigger2 = Alive = 0
trigger3 = roundstate = 4
ignorehitpause = 1
var(24) = 0

;MAX CODING
[State -2, Powerset]
type = Powerset
trigger1 = var(24) > 0
ignorehitpause = 1
value = var(25)

;MAximum PalFx
[State -2, PalFX yellow]
type = PalFX
triggerall = var(24) > 0 
triggerall = var(28) <= 0
trigger1 = MoveType != H && (GameTime%2)=0 
time = 1
add = 104,64,8
ignorehitpause = 1

;MAximum PalFx
[State -2, PalFX white]
type = PalFX 
triggerall = var(28) > 0
trigger1 = MoveType != H && (GameTime%2)=0 
time = 1
add = 248,248,248
ignorehitpause = 1

;MAX CODING
[State -2, cancel var]
type = VarAdd 
trigger1 = var(28) > 0
ignorehitpause = 1
var(28) = -1

[State -2, Attack Down]
type = AttackMulSet
trigger1 = var(24) > 1
value = .8

;============================
; ------ GUARD CRUSH ------- 
;============================

[State -2, GUARD CRUSH CODE]
type = VarAdd
trigger1 = var(19) >= 1
var(19) = -1
ignorehitpause = 1 

[State -2, GUARD CRUSH CODE]
type = VarAdd
trigger1 = var(3) >= 1 && movetype = H && enemy, hitdefattr = SCA, HA, HP
var(3) = -10
ignorehitpause = 1 

[State -2, GUARD CRUSH CODE]
type = VarSet
trigger1 = roundstate = 0
trigger2 = stateno = 160
var(19) = 0
ignorehitpause = 1 

[State -2, GUARD CRUSH CODE]
type = VarSet
trigger1 = roundstate = 0
trigger2 = var(19) <= 0
var(3) = 0
ignorehitpause = 1 

[State -2, GUARD CRUSH CODE]
type = VarSet
trigger1 = Stateno != 150 && stateno != 152 && stateno != 154
var(29) = 0
ignorehitpause = 1 

;============================
; ------- DIZZY CODE -------
;============================
[State -2, reset Dizzy]
type = VarSet
trigger1 = RoundState = 0 || RoundState = 3 || (movetype = H &&  var(5) = 1) || var(4) < 0
ignorehitpause = 1
var(4) = 0

[State -2, reset Dizzy]
type = VarSet
trigger1 = stateno = 5301
ignorehitpause = 1
var(5) = 1

[State -2, reset Dizzy]
type = VarSet
trigger1 = var(4) <= 0 && var(5) = 1
ignorehitpause = 1
var(5) = 0

[State -2, DIZZY CODE]
type = VarAdd
trigger1 = (var(4) = [1,999]) && movetype = H && enemy, hitdefattr = SCA, HA, HP
var(4) = -50
ignorehitpause = 1 

[State -2, DIZZY CODE]
type = VarAdd
trigger1 = (var(4) = [1,999]) && movetype = H && gethitvar(hitcount) >= 5 
var(4) = -20
ignorehitpause = 1 

[State -2, DIZZY CODE]
type = VarAdd
trigger1 = stateno = 5301
trigger1 = var(4) = [1,999]
var(4) = -1
ignorehitpause = 1 

[State -2, DIZZY CODE]
type = VarAdd
trigger1 = var(12) > 0
var(12) = -1
ignorehitpause = 1 

[State -2, DIZZY CODE]
type = Varset
trigger1 = stateno != [5300,5301]
trigger1 = var(12) <= 0
var(4) = 0
ignorehitpause = 1

[State -2, DIZZY CODE]
type = Varset
trigger1 = var(4) > 1000
var(4) = 1000
ignorehitpause = 1 

;============================
; ------ COUNTER HIT -------
;============================

[State -2, COUNTER HIT reset]
type = Varset
trigger1 = p2movetype != H
trigger2 = var(32) > p2life
ignorehitpause = 1
var(32) = 0

[State -2, COUNTER HIT1]
type = Varset
trigger1 = Enemy, movetype = A && enemy, stateno != [0,999]
ignorehitpause = 1
var(20) = 1
 
[State -2, COUNTER HIT2]
type = VarSet
trigger1 = enemy, movetype = I
ignorehitpause = 1
var(20) = 0

[State -2, COUNTER HIT3]
type = VarSet
trigger1 = var(21) > 0 && enemy, movetype = H
ignorehitpause = 1
var(20) = 0

[State -2, COUNTER HIT3]
type = VarSet
trigger1 = Enemy, movetype = A && enemy, stateno = [0,999]
ignorehitpause = 1
var(20) = 0

[State -2, COUNTER HIT4]
type = Varset
trigger1 = stateno != 601 && stateno != 611
trigger1 = var(20) = 1 && movehit
trigger2 = var(20) = 1 && projhit = 1
trigger3 = numhelper(6150) >= 1
trigger3 = var(20) = 1 && helper(6150),movehit
trigger4 = numhelper(6151) >= 1
trigger4 = var(20) = 1 && helper(6151),movehit
trigger5 = numhelper(6400) >= 1
trigger5 = var(20) = 1 && helper(6400),movehit
trigger6 = numhelper(6450) >= 1
trigger6 = var(20) = 1 && helper(6450),movehit
trigger7 = numhelper(1700) >= 1
trigger7 = var(20) = 1 && helper(1700),movehit
trigger8 = numhelper >= 1
trigger8 = var(20) = 1 && helper,projhit = 1
trigger9 = stateno = 1411 || stateno = 1601 || stateno = 1803 || stateno = 1813 || (stateno = [1700,1710]) || (stateno = [1610,1612])
trigger9 = MoveHit
trigger9 = ifelse((stateno = [1700,1710]),1,hitpausetime != 0)
ignorehitpause = 1
var(21) = 3

[State -2, COUNTER HIT reset]
type = Varset
trigger1 = var(21) = 2
ignorehitpause = 1
var(32) = p2life

[State -2, COUNTER HIT9]
type = Varadd
trigger1 = var(21) > 1
ignorehitpause = 1
var(21) = -1

[State -2, COUNTER HIT6]
type = VarSet
trigger1 = p2movetype != H
trigger2 = p2statetype = L
trigger3 = var(32) = 0 && var(21) < 2
ignorehitpause = 1
var(21) = 0

[State -2, COUNTER HIT7]
type = Assertspecial
trigger1 = var(21) > 0 
flag = Nojugglecheck

[State -2, COUNTER HIT8]
type = Varset
triggerall = numtarget >= 1
triggerall = var(21) > 0
trigger1 = stateno != 601 && stateno != 611
trigger1 = var(20) = 1 && movehit && var(22) = 0
trigger2 = var(20) = 1 && projhit = 1 && var(22) = 0
trigger3 = numhelper(6150) >= 1
trigger3 = var(20) = 1 && helper(6150),movehit && var(22) = 0
trigger4 = numhelper(6151) >= 1
trigger4 = var(20) = 1 && helper(6151),movehit && var(22) = 0
trigger5 = numhelper(6400) >= 1
trigger5 = var(20) = 1 && helper(6400),movehit && var(22) = 0
trigger6 = numhelper(6450) >= 1
trigger6 = var(20) = 1 && helper(6450),movehit && var(22) = 0
trigger7 = numhelper(1700) >= 1
trigger7 = var(20) = 1 && helper(1700),movehit && var(22) = 0
trigger8 = numhelper >= 1
trigger8 =  var(20) = 1 && helper,projhit = 1 && var(22) = 0
ignorehitpause = 1
var(22) = 2

[State -2, COUNTER HIT9]
type = Varadd
trigger1 = var(22) > 0
ignorehitpause = 1
var(22) = -1

[State -2, COUNTER HIT10]
type = EnvColor
trigger1 = Movehit && var(22) > 0
trigger2 = projhit = 1 && var(22) > 0
trigger3 = numhelper(6150) >= 1
trigger3 = var(20) = 1 && helper(6150),movehit
trigger4 = numhelper(6151) >= 1
trigger4 = var(20) = 1 && helper(6151),movehit
trigger5 = numhelper(6400) >= 1
trigger5 = var(20) = 1 && helper(6400),movehit
trigger6 = numhelper(6450) >= 1
trigger6 = var(20) = 1 && helper(6450),movehit
trigger7 = numhelper(1700) >= 1
trigger7 = var(20) = 1 && helper(1700),movehit
trigger8 = numhelper >= 1
trigger8 = helper,projhit = 1 && var(22) > 0
value = 248,248,248
time = 1
under = 1
ignorehitpause = 1

[State -2, COUNTER HIT11]
type = AttackMulSet
trigger1 = var(20) = 0
trigger1 = var(24) <= 0
value = 1
ignorehitpause = 0

[State -2, COUNTER HIT12]
type = AttackMulSet
trigger1 = var(20) = 1
trigger1 = var(24) <= 0
value = 1.1
ignorehitpause = 0

[State -2, COUNTER HIT12]
type = AttackMulSet
trigger1 = var(20) = 1
trigger1 = var(24) > 0
value = 0.9
ignorehitpause = 0

[State -2, COUNTER HIT3]
type = VarSet
trigger1 = enemy, movetype = H
ignorehitpause = 1
var(20) = 0

;============================
; ------ REMOVE EXPLOD -----
;============================

[State -2, INTRO]
type = RemoveExplod
trigger1 = StateNo != 190
ID = 6000

[State -2, INTRO]
type = RemoveExplod
trigger1 = StateNo != 194
ID = 6600

[State -2, CHARGE]
type = RemoveExplod
trigger1 = StateNo != 801
ID = 8014

[State -2, OMEGA]
type = RemoveExplod
trigger1 = StateNo != 900 
ID = 900

;============================
; ----- RESET THROW VAR ----
;============================

[State -2, Throw var]
type = Varset
trigger1 = stateno != 601
trigger1 = stateno != 611
var(6) = 0
ignorehitpause = 1

;============================
; ---- RESET AFTER IMAGE ---
;============================
[State -2, After image]
type = AfterImageTime
triggerall = movetype = H
trigger1 = Time = 1
time = 0

;============================
; ------- STOP SOUNDS ------
;============================

[State -2, INTROS]
type = StopSnd
trigger1 = stateno != 190 && stateno != 191 && stateno != 192 && stateno != 193 && stateno != 194 && stateno != 195 && stateno != 196
channel = 1

[State -2, HITTED]
type = StopSnd
trigger1 = life = 0
channel = 2

[State -2, CHARGE]
type = StopSnd
trigger1 = stateno != 800 && stateno != 801
channel = 3

[State -2, HITTED]
type = StopSnd
trigger1 = Stateno != 1500 && stateno != 1510 && stateno != 1550 && stateno != 1560
channel = 5

[State -2, HITTED]
type = StopSnd
trigger1 = Stateno != 1700 && stateno != 1710
channel = 6

[State -2, HITTED]
type = StopSnd
trigger1 = Stateno != 100 && stateno != 1301 && stateno != 1311 && stateno != 3001 && stateno != 3011 && stateno != 3051
channel = 8

;============================
; -- COMBO DAMAGE LIMITTER -
;============================
[State -2, Varadd]
type = Varadd
trigger1 = HitDefAttr = SCA, AA, AP && MoveHit
var(9) = 1
ignorehitpause = 1 
persistent = 0

[State -2, AttackMulSet]
type = Varset
trigger1 = enemy, movetype != H
trigger1 = Var(9) > 0
trigger2 = (stateno = 3000 || stateno = 3010 || stateno = 3050) && time <= 1
trigger3 = (stateno = 3100 || stateno = 3110 || stateno = 3150) && time <= 1
trigger4 = (stateno = 3200 || stateno = 3210 || stateno = 3250) && time <= 1
trigger5 = stateno = 3300 && time <= 1
var(9) = 0

[State -2, AttackMulSet]
type = AttackMulSet
trigger1 = var(9) <= 1
trigger1 = var(20) = 0
trigger1 = var(24) <= 0
value = 1

[State -2, AttackMulSet]
type = AttackMulSet
trigger1 = var(9) <= 1
trigger1 = var(20) = 0
trigger1 = var(24) > 0
value = 0.8

[State -2, AttackMulSet]
type = AttackMulSet
trigger1 = var(9) = [2,4]  
value = .7

[State -2, AttackMulSet]
type = AttackMulSet
trigger1 = var(9) >= 5  
value = .5

;============================
; ---- HIPER PROJ FLASH ----
;============================

[State 3000, Flash]
type = envcolor
trigger1 = projhit6165 = 1
ignorehitpause = 1
time = 1
value = 248,248,248
under = 1

;============================
; --- GENOCIDE CUTTER SND --
;============================

[State -2, var]
type = VarAdd
trigger1 = var(11) >= 0
var(11) = -1
ignorehitpause = 1

[State -2, var]
type = Varset
trigger1 = movetype = H
trigger2 = movetype = A && stateno != [1400,1413]
trigger2 = stateno != [1600,1615]
var(11) = -1
ignorehitpause = 1

[State -2, snd]
type = PlaySnd
trigger1 = var(11) = 1
value = 1400,1
ignorehitpause = 1
Channel = 0

;============================
; ---- Omega Mode Reset ----
;============================
[State -2, Omega]
type = VarSet
trigger1 = roundstate = 0
v =  13
value = 0

;============================
; -- GRAVITY SMASH SPARKS --
;============================
; Big Spark
[State -2, 14]
type = Explod
trigger1 = (p2stateno = [1520,1540]) && p2movetype = H
trigger1 = random < 300
trigger1 = NumExplod(6420) < 3
anim = 6420
ID = 6420
postype = p2
pos = 0,-40
random = 100,100
bindtime = 1
sprpriority = 4

; Small Spark
[State -2, 14]
type = Explod
trigger1 = (p2stateno = [1520,1540]) && p2movetype = H
trigger1 = random < 250
trigger1 = NumExplod(6420) < 3
anim = 6421
ID = 6420
postype = p2
pos = 0,-40
random = 100,100
bindtime = 1
sprpriority = 4

; Ground Spark
[State -2, 14]
type = Explod
trigger1 = (p2stateno = 1545) && p2movetype = H
trigger1 = NumExplod(6422) < 1
anim = 6422
ID = 6422
postype = p2
pos = 0,0
bindtime = 1
sprpriority = 4
facing = -1

;============================
; ----- Throw Limitter -----
;============================
[State -2, throwa]
type = VarSet
trigger1 = HitDefAttr = SCA, NA, AP && MoveContact
var(23) = 15
ignorehitpause = 1 

[State -2, throwb]
type = VarAdd
trigger1 = var(23) >= 1
var(23) = -1
ignorehitpause = 1 


;============================
; ------ Defence Up --------
;============================
[State -2, Defense Up]
type = DefenceMulSet
trigger1 = Life <= 437
value = ifelse(life < 262,.70,.80)

;============================
; ------ Target Drop -------
;============================
[State -2, Target Drop]
type = Targetdrop
trigger1 = movetype = H

;============================
; ------- GS Varset --------
;============================

[State 0, ]
type = VarAdd
trigger1 = var(36) > 0
v =  36
value = -1
ignorehitpause = 1

[State 0, ]
type = VarAdd
trigger1 = var(37) > 0
v =  37
value = -1
ignorehitpause = 1

;============================
; ------ Combo Varset ------
;============================

[State -1, combo varset1]
Type = varset
trigger1 = numtarget = 0
var(18) = 0

[State -2, combo varset2]
Type = varset
triggerall = numtarget >= 1
trigger1 = target, stateno = 605
trigger2 = target, stateno = 614 
trigger3 = target, stateno = 1730
trigger4 = target, stateno = 1735
trigger5 = target, stateno = 1750
trigger6 = (var(21) <= 0) && (target,stateno = [1520,1540])
trigger7 = target, stateno = [1319,1322]
trigger8 = target, stateno = [2020,2023]
trigger9 = target, stateno = 2061
ignorehitpause = 1
var(18) = 1

;============================
; ----- Reppuken Blood -----
;============================

[State 240, BLOOD]
type = Explod
Trigger1 = projhit6050 = 1
trigger1 = numtarget >= 1
trigger1 = target,ishelper = 0
ignorehitpause = 1
anim = 8023
id = 8023
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,-(floor(pos y))-40
bindtime = 1
ownpal = 1

[State 240, bloodvar]
type = VarSet
Trigger1 = projhit6050 = 1
trigger1 = numtarget >= 1
trigger1 = target,ishelper = 0
var(35) = 2
ignorehitpause = 1
persistent = 0

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = ifelse(var(35) = 2,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,0.25,0.5),ifelse(random<500,1,1.5))),(ifelse(random<500,ifelse(random<500,-0.25,-1.25),ifelse(random<500,-2.25,-3.25)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = ifelse(var(35) = 2,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,1.75,2),ifelse(random<500,2.5,3))),(ifelse(random<500,ifelse(random<500,-0.5,-1.5),ifelse(random<500,-2.5,-3.5)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = ifelse(var(35) = 1,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,3.25,3.5),ifelse(random<500,4,4.5))),(ifelse(random<500,ifelse(random<500,-0.75,-1.75),ifelse(random<500,-2.75,-3.75)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = ifelse(var(35) = 1,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,4.75,5),ifelse(random<500,5.5,6))),(ifelse(random<500,ifelse(random<500,-1,-2),ifelse(random<500,-3,-4)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = random < 800
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,0.25,0.75),ifelse(random<500,1.25,1.5))),(ifelse(random<500,ifelse(random<500,-1,-2),ifelse(random<500,-3,-4)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = random < 800
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,1.75,2.25),ifelse(random<500,2.75,3))),(ifelse(random<500,ifelse(random<500,-0.75,-1.75),ifelse(random<500,-2.75,-3.75)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = random < 800
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,3.25,3.75),ifelse(random<500,4.25,4.5))),(ifelse(random<500,ifelse(random<500,-0.5,-1.5),ifelse(random<500,-2.5,-3.5)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(35) > 0
trigger1 = random < 800
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8024
sprpriority = 4
postype = p1
pos = (floor(p2dist x))-20,(floor(pos y))-40
vel = (ifelse(random<500,ifelse(random<500,4.75,5.25),ifelse(random<500,5.75,6))),(ifelse(random<500,ifelse(random<500,-0.25,-1.25),ifelse(random<500,-2.25,-3.25)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 0, ]
type = VarAdd
trigger1 = var(35) > 0
var(35) = -1
ignorehitpause = 1

;============================
; ---- Other Moves Blood ---
;============================

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = ifelse(var(31) = 2,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,0.25,0.5),ifelse(random<500,1,1.5))),(ifelse(random<500,ifelse(random<500,-0.25,-1.25),ifelse(random<500,-2.25,-3.25)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = ifelse(var(31) = 2,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,1.75,2),ifelse(random<500,2.5,3))),(ifelse(random<500,ifelse(random<500,-0.5,-1.5),ifelse(random<500,-2.5,-3.5)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = ifelse(var(31) = 1,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,3.25,3.5),ifelse(random<500,4,4.5))),(ifelse(random<500,ifelse(random<500,-0.75,-1.75),ifelse(random<500,-2.75,-3.75)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = ifelse(var(31) = 1,1,random < 800)
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,4.75,5),ifelse(random<500,5.5,6))),(ifelse(random<500,ifelse(random<500,-1,-2),ifelse(random<500,-3,-4)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = random < 800
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,0.25,0.75),ifelse(random<500,1.25,1.5))),(ifelse(random<500,ifelse(random<500,-1,-2),ifelse(random<500,-3,-4)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = random < 800
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,1.75,2.25),ifelse(random<500,2.75,3))),(ifelse(random<500,ifelse(random<500,-0.75,-1.75),ifelse(random<500,-2.75,-3.75)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = random < 800
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,3.25,3.75),ifelse(random<500,4.25,4.5))),(ifelse(random<500,ifelse(random<500,-0.5,-1.5),ifelse(random<500,-2.5,-3.5)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 240, BLOOD]
type = Explod
Trigger1 = var(31) > 0
trigger1 = random < 800 
ignorehitpause = 1
persistent = 1
anim = ifelse(random < 500, 8024,ifelse(random < 500,8025,8026))
id = 8025
sprpriority = 4
postype = p1
pos = var(33),var(34)
vel = (ifelse(random<500,ifelse(random<500,4.75,5.25),ifelse(random<500,5.75,6))),(ifelse(random<500,ifelse(random<500,-0.25,-1.25),ifelse(random<500,-2.25,-3.25)))
accel = 0,(ifelse(random<500,ifelse(random<500,0.1,0.2),ifelse(random<500,0.3,0.4)))
bindtime = 1
ownpal = 1

[State 0, ]
type = VarAdd
trigger1 = var(31) > 0
var(31) = -1
ignorehitpause = 1

;============================
; --------- DEBUG ----------
;============================
[State -2, DEBUG]
trigger1 = 1
type = DisplayToClipboard
ignorehitpause = 1
text = "DIZZY VAR = %d/1000 GUARD CRUSH VAR = %d/1000 \n Rugal Bernstein by Elphizo"
params = var(4), var(3)

;============================
; ------- States -3 --------
;============================

[Statedef -3]

;============================
; ----------- AI -----------
;============================

; Kamek and Luchini appear to have been the first ones to use the IsHomeTeam AI
; activation concept.
; Feel free to move this controller to your character's intro state for slightly
; better efficiency.
[State -3, SetAI]
type = VarSet
triggerall = Alive
triggerall = IsHomeTeam
trigger1 = TeamSide = 2
trigger2 = MatchNo > 1
var(58) = 1

[State -3, AI Helper - Compatibly Partnered Version]
type = Helper
trigger1 = !var(58)
trigger1 = !NumHelper(9742)
trigger1 = RoundState = 2
trigger1 = Alive
trigger1 = NumPartner
trigger1 = Partner,SelfAnimExist(9741)
HelperType = normal
name = "AI Helper (Simul Version)"
ID = 9742
pos = 9999999,99999
StateNo = 9742
KeyCtrl = 1
PauseMoveTime = 2147483647
SuperMoveTime = 2147483647

; If you want to use the Guard mode, Dummy mode, Distance, or Button jam dummy
; control options in Training mode without activating the dummy's AI while
; working on your character, then all you need to do is temporarily disable
; this controller.  Or, if you want to permanently disable this controller in
; Training mode, then you could use the Training mode detection code available
; on my site ( http://www.mugenguild.net/~winane/ ), and then just add a
; "(var(59)&63)>30" triggerall to this controller.
[State -3, AI Helper]
type = Helper
triggerall = !var(58)
triggerall = !NumHelper(9741)
triggerall = RoundState = 2
triggerall = Alive
trigger1 = !NumPartner
trigger2 = !(Partner,SelfAnimExist(9741))
HelperType = normal
name = "AI Helper"
ID = 9741
pos = 9999999,99999
StateNo = 9741
KeyCtrl = 1
PauseMoveTime = 2147483647
SuperMoveTime = 2147483647

[State -3, TurnBackOnAI]
type = VarSet
trigger1 = var(58) = -2
trigger1 = RoundState = 2
trigger1 = Alive
var(58) = 1

; This method works somewhat in Linux Mugen version 2002.04.14,
; whereas the old humanly-impossible commands method does not.
; It is very important that this controller NOT be moved to State -2.
; Note that this part won't work nearly as well if AI.Cheat is turned off
; in mugen.cfg.
[State -3, XOR]
type = VarSet
triggerall = var(58)!=1
triggerall = !var(56)
triggerall = var(57) = GameTime-1
trigger1 = command = "a" ^^ command = "a2"
trigger2 = command = "b" ^^ command = "b2"
trigger3 = command = "c" ^^ command = "c2"
trigger4 = command = "x" ^^ command = "x2"
trigger5 = command = "y" ^^ command = "y2"
trigger6 = command = "z" ^^ command = "z2"
trigger7 = command = "start" ^^ command = "start2"
trigger8 = command = "holda" ^^ command = "holda2"
trigger9 = command = "holdb" ^^ command = "holdb2"
trigger10 = command = "holdc" ^^ command = "holdc2"
trigger11 = command = "holdx" ^^ command = "holdx2"
trigger12 = command = "holdy" ^^ command = "holdy2"
trigger13 = command = "holdz" ^^ command = "holdz2"
trigger14 = command = "holdstart" ^^ command = "holdstart2"
trigger15 = command = "holdfwd" ^^ command = "holdfwd2"
trigger16 = command = "holdback" ^^ command = "holdback2"
trigger17 = command = "holdup" ^^ command = "holdup2"
trigger18 = command = "holddown" ^^ command = "holddown2"
trigger19 = command = "recovery" ^^ command = "recovery2"
;Add more as desired. (See my notes in the CMD.)
var(58) = 1

; This controller must be placed here, after the above XOR VarSet
; controller and before the below GameTime VarSet controller.
[State -3, fiXOR]
type = VarSet
trigger1 = !HitPauseTime
trigger2 = var(57) < GameTime-1
var(56) = HitPauseTime
IgnoreHitPause = 1

[State -3, GameTimeVar]
type = VarSet
trigger1 = 1
var(57) = GameTime
IgnoreHitPause = 1

;============================
; ---- MKY LIN LIFE ADD ----
;============================

;Compatibility with Lin by Misamu K Young 
[State -3,lin s lifeadd ]
type = lifeadd
triggerall = life >50 && time%5 =0 
trigger1 = enemy,name = "lin"
trigger1 = enemy,var(18) = 1
value = -1

[State -3, 1];kill the corner push bug
type = VelSet
trigger1 = FrontEdgeDist < 10 && Vel x > 0.1
x = 0.1

;============================
; ------- Slow Down --------
;============================

[State -3, Slow Down]
type = Pause
;triggerall = RoundState = 2
triggerall = !(((stateno=3000)||(stateno=3010)||(stateno=3050)||(stateno=3100)||(stateno=3110)||(stateno=3150)||(stateno=3200)||(stateno=3210)||(stateno=3250)||(stateno=3300))&&(time=[1,30]))
triggerall = stateno != 900
trigger1 = ProjHitTime(6050) = [13,24]
trigger2 = ProjHitTime(6100) = [13,24]
trigger3 = ProjHitTime(6101) = [4,15]
trigger4 = ProjHitTime(6160) = [13,24]
trigger5 = ProjHitTime(6165) = [13,24]
trigger6 = ProjHitTime(6410) = [13,24]
time = 1
movetime = 0
ignorehitpause = 1

[State -3, Slow Down]
type = Pause
;triggerall = RoundState = 2
triggerall = !(((stateno=3000)||(stateno=3010)||(stateno=3050)||(stateno=3100)||(stateno=3110)||(stateno=3150)||(stateno=3200)||(stateno=3210)||(stateno=3250)||(stateno=3300))&&(time=[1,30]))
triggerall = stateno != 900
trigger1 = var(30) = [13,24]
time = 1
movetime = 0
ignorehitpause = 1

[State 0, ]
type = VarAdd
trigger1 = var(30) > 0
var(30) = 1
ignorehitpause = 1

[State 0, ]
type = VarSet
trigger1 = var(30) > 24
var(30) = 0
ignorehitpause = 1
